# Python Try-Except (alternate)...

def divider (a, b):
    '''Smarter divider function.'''
    print(f'divider({a}, {b})', end='')

    # Attempt a division...
    try:
        retval = a / b
        print(f' = {retval}\n')
        return retval

    # Catch divide-by-zero errors...
    except ZeroDivisionError:
        print(' *** Opps! Division by zero!\n')

    # Catch divide-by-zero errors...
    except TypeError:
        print(f' *** Invalid operands: {a}÷{b}\n')

    return None


# Try some dividing...
divider( 1, 3)
divider(42,23)
divider(42, 0)
divider('a',5)

