# Passing functions to other functions...

def add_function (a, b):
    "Add two items (a+b)."
    return float(a+b)

def subtract_function (a, b):
    "Subtract two items (a-b)."
    return float(a-b)

def multiply_function (a, b):
    "Multiply two items (a*b)."
    return float(a*b)

def divide_function (a, b):
    "Divide two items (a/b)."
    if b==0: return 0.0
    return float(a/b)

def math_operation (op, a, b):
    "Do a given math operation."
    return op(a, b)


# Do the math...
x, y = 21, 42

result = math_operation(add_function, x, y)
print(f'A+B = {result:+6.1f}')

result = math_operation(subtract_function, x, y)
print(f'A+B = {result:+6.1f}')

result = math_operation(multiply_function, x, y)
print(f'A*B = {result:+6.1f}')

result = math_operation(divide_function, x, y)
print(f'A/B = {result:+6.1f}')

print()

