# Function objects...

def spam ():
    '''My delicious Spam function.'''
    ...

def eggs ():
    '''My wonderful Eggs function.'''
    ...

def bacon ():
    '''My tasty Bacon function.'''
    ...


def whats_my_name (function):
    '''Print function's name and docstring.'''
    print(f'Function: {function.__name__}')
    print(function.__doc__)
    print()


# Direct function references...
print('Direct references...')
print('====================')
whats_my_name(spam)
whats_my_name(eggs)
whats_my_name(bacon)
print()

# Create function aliases...
ftn1 = spam
ftn2 = eggs
ftn3 = bacon

# Use the aliases; same thing...
print('Alias references...')
print('===================')
whats_my_name(ftn1)
whats_my_name(ftn2)
whats_my_name(ftn3)
print()

