# Printable objects...

class MyObject:
    '''Example class.'''

    def __repr__ (self):
        '''Return a debug string.'''
        return f'<{type(self).__name__} @{id(self):012x}>'

    def __str__ (self):
        '''Return a string version of object.'''
        return "Hello!"


# Create a new MyObject instance...
obj = MyObject()

# Print the object itself...
print(obj)

# Use an f-string to print string version...
print(f'{obj}')
print(f'{obj!s}')

# Get and print the object's string value...
s = str(obj)
print(s)
print()

# Use an f-string to print debug version...
print(f'{obj = }')
print(f'{obj!r}')

# Get and print the object's debug value...
r = repr(obj)
print(r)
print()

#:name::This is Python! (part 4)
#:link::https://thehardcorecoder.com/2026/02/02/this-is-python-part-4/
#:date::2026-02-02
