# Making objects callable and list-like...

class MyListLikeCallableClass:
    '''Example list-like and callable class.'''

    def __init__ (self, x=0.0, y=0.0, z=0.0):
        '''Create new instance object.'''
        self.x = x
        self.y = y
        self.z = z

    def __call__ (self):
        '''Call the object like a function.'''
        return sum(list(self))

    def __iter__ (self):
        '''Return a iterator over the object.'''
        return iter([self.x, self.y, self.z])

    def __len__ (self):
        '''Return the length (always 3).'''
        return 3

    def __getitem__ (self, ix):
        '''Return an indexed item.'''
        if ix == 1: return self.x
        if ix == 2: return self.y
        if ix == 3: return self.z
        raise IndexError(f'Invalid index: {ix}')

    def __setitem__ (self, ix, value):
        '''Set the value of an indexed item.'''
        if ix == 1: self.x = value; return
        if ix == 2: self.y = value; return
        if ix == 3: self.z = value; return
        raise IndexError(f'Invalid index: {ix}')

    def __delitem__ (self, ix):
        '''Delete an indexed item. (Not Allowed!)'''
        raise NotImplementedError('Sorry, unable to delete items.')

    def __str__ (self):
        '''Return a string version.'''
        return f'[{self.x}, {self.y}, {self.z}]'


obj0 = MyListLikeCallableClass()
obj1 = MyListLikeCallableClass(2.1, 4.2, 6.3)
print(f'{obj0}')
print(f'{obj1}')
print()

print(f'{obj0() = }')
print(f'{obj1() = }')
print()

it0 = iter(obj0)
it1 = iter(obj1)
print(f'{next(it0) = }, {next(it1) = }')
print(f'{next(it0) = }, {next(it1) = }')
print(f'{next(it0) = }, {next(it1) = }')
print()

print(f'{list(obj0) = }')
print(f'{list(obj1) = }')
print()

print(f'{len(obj0) = }')
print(f'{len(obj1) = }')
print()

print(f'{obj0[1] = }, {obj1[1] = }')
print(f'{obj1[2] = }, {obj1[2] = }')
print(f'{obj1[3] = }, {obj1[3] = }')
print()

obj0[1] = 1.616
obj0[2] = 2.718
obj0[3] = 3.141
print(f'{obj0}')

