import tkinter as tk
import tkinter.messagebox as msgbox

kwarg = lambda nm,dflt,typ,kw: typ(kw[nm]) if nm in kw else dflt

class SimpleWindowApp:
    '''Simple Tk Window class.'''

    def __init__ (self, **kwargs):
        '''New BasicWindowApp instance.'''
        self.title = kwarg('title', 'The Window', str, kwargs)
        self.geom  = kwarg('geo', '480x240+300+100', str, kwargs)

        self.root = tk.Tk()
        self.root.title(self.title)
        self.root.geometry(self.geom)
        self.root.bind('<Escape>', self.app_exit)

        # Return root object...
        self._widgets()
        self._menubar()

    def command (self, cmd_id):
        '''Command handler.'''
        print(f'Command: {cmd_id}')
        if cmd_id.endswith('Exit'):
            self.app_exit()

    def app_exit (self, *args):
        '''Close window.'''
        print('Exit App')
        self.root.destroy()

    def app_about (self, *args):
        '''About message box.'''
        msgbox.showinfo('About', 'Simple Tk Application.')

    def _widgets (self):
        '''Create window widgets.'''
        self.wndw = tk.Frame(self.root, bg='#999999', relief='flat')
        self.wndw.pack(fill='both', expand=True, padx=4, pady=(0,4))

        self.lbl_top = tk.Label(self.wndw)
        self.lbl_top['text'] = 'Step by step, this app grows and grows!'
        self.lbl_top['bg'] = '#334455'
        self.lbl_top['fg'] = '#ffcc66'
        self.lbl_top['relief'] = 'raised'
        self.lbl_top['border'] = 2
        self.lbl_top['font'] = ('Arial', 12, 'bold')
        self.lbl_top.pack(side='top', fill='x', ipady=7)

        def proxy (button_id):
            '''Widgets Command proxy.'''
            return lambda: self.command(f'B:{button_id}')

        self.cmndbtns = tk.Frame(self.wndw)
        self.lbl_cmnds = tk.Label(self.cmndbtns, text='Commands:')
        self.lbl_cmnds.config(font=('Arial', 11, 'bold'), fg='#000099')

        props = lambda ix: dict(text=f'Run #{ix}', command=proxy(f'#{ix}'))
        self.btn_cmnd1 = tk.Button(self.cmndbtns, **props(1))
        self.btn_cmnd2 = tk.Button(self.cmndbtns, **props(2))
        self.btn_cmnd3 = tk.Button(self.cmndbtns, **props(3))
        self.btn_cmnd4 = tk.Button(self.cmndbtns, **props(4))
        self.btn_exit  = tk.Button(self.cmndbtns)
        self.btn_exit['text'] = text='Exit'
        self.btn_exit['command'] = proxy('Exit')

        self.lbl_cmnds.pack(side='left')
        self.btn_cmnd1.pack(side='left', padx=(10,0))
        self.btn_cmnd2.pack(side='left')
        self.btn_cmnd3.pack(side='left')
        self.btn_cmnd4.pack(side='left')
        self.btn_exit.pack(side='left', fill='x', expand=True)
        self.cmndbtns.pack(side='top', fill='x')

        self.apparea = tk.Frame(self.wndw, border=3)
        self.apparea.pack(side='top', fill='both', expand=True)
        self.apparea.config(bg='#336699', relief='sunken')

    def _menubar (self):
        ''' Create menubar.'''
        self.menubar = tk.Menu(self.root)

        def proxy (menu_id):
            '''Menu Command proxy.'''
            return lambda: self.command(f'M:{menu_id}')

        # Create File Sub-Menu...
        self.mbarFile = tk.Menu(self.menubar, name='fileMenu', tearoff=0)
        self.mbarFile.add_command(label='New', command=proxy('New'))
        self.mbarFile.add_command(label='Open...', command=proxy('Open'))
        self.mbarFile.add_command(label='Save', command=proxy('Save'))
        self.mbarFile.add_command(label='Save As...', command=proxy('SaveAs'))
        self.mbarFile.add_separator()
        self.mbarFile.add_command(label='Exit', command=proxy('Exit'))

        # Create Edit Sub-Menu...
        self.mbarEdit = tk.Menu(self.menubar, name='editMenu', tearoff=0)
        self.mbarEdit.add_command(label='Copy' , command=proxy('Copy'))
        self.mbarEdit.add_command(label='Paste', command=proxy('Paste'))

        # Create Help Sub-Menu...
        self.mbarHelp = tk.Menu(self.menubar, name='helpMenu', tearoff=0)
        self.mbarHelp.add_command(label='About', command=self.app_about)

        # Add sub-menus to MenuBar...
        self.menubar.add_cascade(label='File', menu=self.mbarFile)
        self.menubar.add_cascade(label='Edit', menu=self.mbarEdit)
        self.menubar.add_cascade(label='Help', menu=self.mbarHelp)

        # Add menubar to main window...
        self.root.config(menu=self.menubar)

    def __repr__ (self):
        return f'<{type(self).__name__} @{id(self):08x}>'


if __name__ == '__main__':
    print()
    app = SimpleWindowApp()
    print(app)
    app.root.mainloop()
    print()

