import tkinter as tk
import tkinter.messagebox as msgbox

kwarg = lambda nm,dflt,typ,kw: typ(kw[nm]) if nm in kw else dflt

class BasicWindowApp:
    '''Simple Tk Window class.'''

    def __init__ (self, **kwargs):
        '''New BasicWindowApp instance.'''
        self.title = kwarg('title', 'The Window', str, kwargs)
        self.geom  = kwarg('geo', '480x240+300+100', str, kwargs)

        self.root = tk.Tk()
        self.root.title(self.title)
        self.root.geometry(self.geom)
        self.root.bind('<Escape>', self.app_exit)

        # Return root object...
        self._menubar()

    def command (self, command):
        '''Command handler.'''
        print(f'Command: {command}')

    def app_exit (self, *args):
        '''Close window.'''
        print('Exit App')
        self.root.destroy()

    def app_about (self, *args):
        '''About message box.'''
        msgbox.showinfo('About', 'Simple Tk Application.')

    def _menubar (self):
        ''' Create menubar.'''
        self.menubar = tk.Menu(self.root)

        def proxy (menu_id):
            '''Menu Command proxy.'''
            return lambda: self.command(f'M:{menu_id}')

        # Create File Sub-Menu...
        self.mbarFile = tk.Menu(self.menubar, name='fileMenu', tearoff=0)
        self.mbarFile.add_command(label='New', command=proxy('New'))
        self.mbarFile.add_command(label='Open...', command=proxy('Open'))
        self.mbarFile.add_command(label='Save', command=proxy('Save'))
        self.mbarFile.add_command(label='Save As...', command=proxy('SaveAs'))
        self.mbarFile.add_separator()
        self.mbarFile.add_command(label='Exit', command=self.app_exit)

        # Create Edit Sub-Menu...
        self.mbarEdit = tk.Menu(self.menubar, name='editMenu', tearoff=0)
        self.mbarEdit.add_command(label='Copy' , command=proxy('Copy'))
        self.mbarEdit.add_command(label='Paste', command=proxy('Paste'))

        # Create Help Sub-Menu...
        self.mbarHelp = tk.Menu(self.menubar, name='helpMenu', tearoff=0)
        self.mbarHelp.add_command(label='About', command=self.app_about)

        # Add sub-menus to MenuBar...
        self.menubar.add_cascade(label='File', menu=self.mbarFile, underline=0)
        self.menubar.add_cascade(label='Edit', menu=self.mbarEdit, underline=0)
        self.menubar.add_cascade(label='Help', menu=self.mbarHelp, underline=0)

        # Add menubar to main window...
        self.root.config(menu=self.menubar)

    def __repr__ (self):
        return f'<{type(self).__name__} @{id(self):08x}>'


if __name__ == '__main__':
    print()
    app = BasicWindowApp()
    print(app)
    app.root.mainloop()
    print()

