import tkinter as tk
import tkinter.messagebox as msgbox

def open_the_window (ttl='The Window', geo='480x240+300+100'):
    '''Create a new window.'''

    def menu_command ():
        '''Handle menu selection.'''
        print('Menu Choice.') #ATTN: not helpful!

    def window_close (): #ATTN: bug!
        '''Close the window.'''
        root.destroy()

    def about ():
        '''Popup the About message box.'''
        msgbox.showinfo('About', 'Simple Tk Application.')

    def build_menubar ():
        ''' Create real menubar.'''
        menubar = tk.Menu(root)

        # Create File Sub-Menu...
        mbarFile = tk.Menu(menubar, name='fileMenu', tearoff=0)
        mbarFile.add_command(label='New', command=menu_command)
        mbarFile.add_command(label='Open...', command=menu_command)
        mbarFile.add_command(label='Save', command=menu_command)
        mbarFile.add_command(label='Save As...', command=menu_command)
        mbarFile.add_separator()
        mbarFile.add_command(label='Exit', command=window_close)

        # Create Edit Sub-Menu...
        mbarEdit = tk.Menu(menubar, name='editMenu', tearoff=0)
        mbarEdit.add_command(label='Copy' , command=menu_command)
        mbarEdit.add_command(label='Paste', command=menu_command)

        # Create Help Sub-Menu...
        mbarHelp = tk.Menu(menubar, name='helpMenu', tearoff=0)
        mbarHelp.add_command(label='About', command=about)

        # Add sub-menus to MenuBar...
        menubar.add_cascade(label='File', menu=mbarFile, underline=0)
        menubar.add_cascade(label='Edit', menu=mbarEdit, underline=0)
        menubar.add_cascade(label='Help', menu=mbarHelp, underline=0)

        # Add menubar to main window...
        root.config(menu=menubar)

    # Open-The-Window thread starts here...
    root = tk.Tk()
    root.title(ttl)
    root.geometry(geo)
    root.bind('<Escape>', window_close)

    # Return root object...
    build_menubar()
    return root


if __name__ == '__main__':
    print()
    app = open_the_window()
    app.mainloop()
    print()

