import tkinter as tk
import tkinter.messagebox as msgbox

def open_the_window (ttl='The Window', geo='480x240+300+100'):
    '''Create a new window.'''
    root = tk.Tk()
    root.title(ttl)
    root.geometry(geo)

    def window_close ():
        '''Close the window.'''
        root.destroy()

    def about ():
        '''Popup the About message box.'''
        msgbox.showinfo('About', 'Simple Tk Application.')

    # Create simple menubar...
    menubar = tk.Menu(root)
    menubar.add_command(label='Exit', command=window_close)
    menubar.add_separator()
    menubar.add_command(label='About', command=about)
    # Add menubar to main window...
    root.config(menu=menubar)

    # Return root object...
    return root


if __name__ == '__main__':
    print()

    # Create window and loop...
    app = open_the_window()
    app.mainloop()
    print()

