import tkinter as tk

def open_the_window (ttl='The Window', geo='480x240+300+100'):
    '''Create a new window.'''
    root = tk.Tk()
    root.title(ttl)
    root.geometry(geo)

    def window_close ():
        '''Close the window.'''
        # Destroy the main window...
        # (Returns us from mainloop.)
        root.destroy()

    # Create simple menubar...
    menubar = tk.Menu(root)

    # Add a command to the menubar...
    menubar.add_command(label='Exit', command=window_close)

    # Add menubar to main window...
    root.config(menu=menubar)

    # Return root object...
    return root


if __name__ == '__main__':
    print()
    # Create the window...
    app = open_the_window()

    # Start the window loop...
    app.mainloop()
    print()

