from sys import argv, exc_info
from traceback import extract_tb
from examples import kwarg, dualnumber, make_chart

def main (**kwargs):
    '''Dual number demo.'''
    fname = kwarg('fname', 'dualnums.png', str, kwargs)
    fpath = kwarg('fpath', r'C:\Demo\HCC\Python', str, kwargs)
    poly  = kwarg('poly', '2,-7,5', str, kwargs)
    xmin  = kwarg('xmin', -5.0, float, kwargs)
    xmax  = kwarg('xmax', +5.0, float, kwargs)
    ymin  = kwarg('ymin', -5.0, float, kwargs)
    ymax  = kwarg('ymax', +5.0, float, kwargs)
    xtix  = kwarg('xtix', '1.0, 0.1', str, kwargs)
    ytix  = kwarg('ytix', '1.0, 0.1', str, kwargs)
    divs  = kwarg('divs', 500, int, kwargs)

    coefficients = [float(n.strip()) for n in reversed(poly.split(','))]

    def f (x):
        accum = float()
        for expon,coe in enumerate(coefficients):
            accum += (coe * pow(x,expon))
        return accum

    # Generate X-axis...
    stepsize = (xmax-xmin)/divs
    xs = [xmin+(ix*stepsize) for ix in range(divs)]

    # Generate data: f(x) and g(x)...
    fys = [f(x) for x in xs]
    gys = [dualnumber.differentiate(f,x) for x in xs]

    props = {
        'fname': fname, 'fpath':fpath,
        'xmin': xmin, 'xmax': xmax,
        'ymin': ymin, 'ymax': ymax,
        'xticks': tuple(float(n.strip()) for n in xtix.split(',',1)),
        'yticks': tuple(float(n.strip()) for n in ytix.split(',',1)),
    }
    make_chart(xs, fys,gys, **props)

if __name__ == '__main__':
    print(argv[0])
    print()

    # Convert commandline args to keyword args...
    kwargs = {}
    for arg in argv[1:]:
        nam,val = arg.split('=',1)
        kwargs[nam] = val

    # Call main from inside a try/except...
    try:
        main(**kwargs)

    except:
        # Print exception data in a nice, clear way...
        etype, evalue, tb = exc_info()
        ts = extract_tb(tb)
        print()
        print(f'{etype.__name__}: {evalue!s}')
        print()
        for t in ts[-5:]:
            print(f'[{t[1]}] {t[2]}  ({t[0]})')
            print(f'    {t[3]}')
            print()
        print()
    print()

