from examples import make_chart

if __name__ == '__main__':
    print()
    fname = 'dualnums-test.png'

    # Make some data...
    nsteps = 200
    stepsize = 6.0 / 200

    # The Xs from from -3.0 to +3.0 (200 steps)...
    xs = [-3.0+(ix*stepsize) for ix in range(nsteps)]

    # f(x) = x^3
    ys1 = [pow(x,3) for x in xs]
    # f'(x) = 3x^2
    ys2 = [3*pow(x,2) for x in xs]

    # Make a chart of the data...
    props = dict(xmin=-3,xmax=+3, ymin=-8,ymax=+8, fname=fname)
    make_chart(xs, ys1,ys2, **props)
    print()

