from examples import kwarg

def make_chart (xs, ys0,ys1, **kwargs):
    '''Create a chart.'''
    from os import path
    from matplotlib import pyplot as plt
    from matplotlib.ticker import MultipleLocator
    from matplotlib.ticker import FormatStrFormatter
    from matplotlib.patches import Patch
    from examples import kwarg

    fname  = kwarg('fname', 'dualnums.png', str, kwargs)
    fpath  = kwarg('fpath', r'C:\Demo\HCC\Python', str, kwargs)
    xmin   = kwarg('xmin', -5, int, kwargs)
    xmax   = kwarg('xmax', +5, int, kwargs)
    ymin   = kwarg('ymin', -10, int, kwargs)
    ymax   = kwarg('ymax', +10, int, kwargs)
    xticks = kwarg('xticks', (1.0, 0.1), tuple, kwargs)
    yticks = kwarg('yticks', (1.0, 0.1), tuple, kwargs)
    fcolor = kwarg('fc', '#7f7f7f', str, kwargs)
    gcolor = kwarg('gc', '#ff0000', str, kwargs)
    latex = r'$\left[=\frac{d}{dx}f(x)\right]$'
    title  = f'f(x) & g(x) {latex} with dual numbers'

    # Create a new plot 6.0 inches wide and 8.0 inches tall...
    fig, ax = plt.subplots()
    fig.set_figwidth(6.0)
    fig.set_figheight(8.0)
    fig.suptitle(title, fontsize=14, fontweight='bold')
    fig.subplots_adjust(left=0.065, right=0.990, bottom=0.07, top=0.93)

    # Define X-axis properties...
    ax.set_xlim(xmin, xmax)
    ax.xaxis.set_major_locator(MultipleLocator(xticks[0]))
    ax.xaxis.set_minor_locator(MultipleLocator(xticks[1]))
    ax.xaxis.set_major_formatter(FormatStrFormatter('%.0f'))

    # Define Y-axis properties...
    ax.set_ylim(ymin, ymax)
    ax.yaxis.set_major_locator(MultipleLocator(yticks[0]))
    ax.yaxis.set_minor_locator(MultipleLocator(yticks[1]))
    ax.yaxis.set_major_formatter(FormatStrFormatter('%.0f'))

    # Define background grid properties...
    props = dict(axis='both', ls='-', alpha=1.0)
    ax.grid(which='major', color='#9f9f9f', lw=1.0, zorder=1, **props)
    ax.grid(which='minor', color='#bfbfbf', lw=0.6, zorder=0, **props)

    props = dict(axis='both', direction='out', color='#000000')
    ax.tick_params(which='major', **props)
    ax.tick_params(which='minor', **props)

    # Draw the X and Y axes...
    ax.axhline(0.0, lw=1.2, color='#000000', alpha=1.00, zorder=10)
    ax.axvline(0.0, lw=1.2, color='#000000', alpha=1.00, zorder=10)

    # Plot f(x) and g(x)...
    ax.plot(xs,ys0, label='f(x)', c=fcolor, lw=2.5, alpha=0.8, zorder=11)
    ax.plot(xs,ys1, label='g(x)', c=gcolor, lw=2.5, alpha=0.8, zorder=12)

    # Define legend...
    patchs = [
        Patch(facecolor=fcolor, edgecolor='#000000', lw=0.75),
        Patch(facecolor=gcolor, edgecolor='#000000', lw=0.75),
    ]
    labels = ['f(x)', 'g(x)']
    fig.legend(
        patchs,
        labels,
        loc='lower right',
        ncols=2,
        fontsize=10,
        bbox_to_anchor=(0.99,0.00)
    )

    # Save the chart as an image file...
    filename = path.join(fpath,fname) if fpath else fname
    fig.savefig(filename)
    print(f'wrote: {filename}')
    print()

