class BasicDecoratorClass:
    '''Basic Decorator *class*. Use instances for decorators.'''

    class DecoratorFunctionClass:
        '''Decorator class for wrapping a function.'''

        def __init__ (self, function):
            '''New wrapper instance; receives decorated function.'''
            print(f'@DecoratorFunction({function})')
            self.function = function

        def __call__ (self, *args, **kwargs):
            '''Call to the decorated function.'''
            print(f'Decorator({len(args)} args, {len(kwargs)} kwargs)')

            # Call the wrapped function; return its return value...
            return self.function(*args, **kwargs)

    def __init__ (self):
        '''New decorator instance.'''
        print(f'@Decorator()')

    def __call__ (self, function):
        '''Return a new wrapper for a function.'''
        return BasicDecoratorClass.DecoratorFunctionClass(function)

