from examples import StaticMethod, ClassMethod, ObjIdStr

class TestClass:
    '''Example class #1.'''

    @StaticMethod
    def barfoo (a, b, c):
        return a*b*c

    @ClassMethod
    def foobar (cls, x, y):
        return x+y

    def __repr__ (self):
        return ObjIdStr(self)

if __name__ == '__main__':
    print()

    # Access through the class...
    print(f'{TestClass.barfoo(21,42,63)=}')
    print(f'{TestClass.foobar(21,42)=}')
    print()

    # Access through an instance...
    g = TestClass()
    print(f'{g=}')
    print(f'{g.barfoo(63,84,108)=}')
    print(f'{g.foobar(63,84)=}')
    print()

    # Try setting or deleting on the instance...
    try: g.barfoo = [1,2,3]
    except Exception as e: print(e)

    try: del g.barfoo
    except Exception as e: print(e)

    # Try setting or deleting on the instance...
    try: g.foobar = [1,2,3]
    except Exception as e: print(e)

    try: del g.foobar
    except Exception as e: print(e)
    print()

    # Try setting or deleting on the class...
    try:
        tmp = TestClass.barfoo
        TestClass.barfoo = [1,2,3]
        print(f'{TestClass.barfoo=}')
    except Exception as e: print(e)
    finally: TestClass.barfoo = tmp

    try:
        del TestClass.barfoo
        print(f'{hasattr(TestClass,"barfoo")=}')
    except Exception as e: print(e)

    # Try setting or deleting on the class...
    try:
        tmp = TestClass.foobar
        TestClass.foobar = [1,2,3]
        print(f'{TestClass.foobar=}')
    except Exception as e: print(e)
    finally: TestClass.foobar = tmp

    try:
        del TestClass.foobar
        print(f'{hasattr(TestClass,"foobar")=}')
    except Exception as e: print(e)
    print()

