from math import sqrt
from examples import StaticMethod, ClassMethod

class point:
    '''Example class.'''
    dent = 42

    def __init__ (self, x=0.0, y=0.0):
        '''New point instance.'''
        self.x = float(x)
        self.y = float(y)

    @StaticMethod
    def distance (a, b) -> float:
        '''Example static method.'''
        print(f'distance({a}, {b})')
        return sqrt(pow(a.x-b.x,2) + pow(a.y-b.y,2))

    @ClassMethod
    def setdent (cls, value):
        '''Example class method.'''
        print(f'setdent({cls.__name__}, {value})')
        point.dent = value
        return point.dent

    def __repr__ (self):
        return f'<{type(self).__name__} [{self.dent}] @{id(self):08x}>'

    def __str__ (self):
        return f'[{self.x:.3f} x {self.y:.3f}]'

if __name__ == '__main__':
    print()
    p0 = point()
    p1 = point(-5, +5)

    print(f'{point.distance(p0, p1)}')
    print(f'{p0.distance(p0, p1)}')
    print()

    print(f'{point.setdent(27)}')
    print(f'{p0.setdent(31)}')
    print()

