def StaticMethod (method):
    '''Decorator to turn a method into a static method.'''

    # Gather some basic info...
    ftn_name = method.__name__
    #print(f'@StaticMethod: {ftn_name}')

    class StaticMethodProperty:
        '''Property class to implement the static method wrapper.'''

        def __init__ (self, ftn):
            #print(f'{ObjIdStr(self)} init')
            self.method = ftn

        def __set_name__ (self, owner, name):
            # Remember the function's name...
            self.name = name

        def __get__ (self, obj, cls):
            '''Access the property.'''
            caller = '<null>' if obj is None else ObjIdStr(obj)
            #print(f'{ObjIdStr(self)} get: {caller}')
            def proxy (*args, **kwargs):
                '''Proxy function that wraps class method.'''
                return self.method(*args, **kwargs)
            return proxy

        def __set__ (self, obj, value):
            '''(Only protects calls on instance objects.'''
            raise NotImplementedError(f'You may not modify {self.name}!')

        def __delete__ (self, obj):
            '''(Only protects calls on instance objects.'''
            raise NotImplementedError(f'You may not delete {self.name}!')

    # Return new instance of StaticMethodProperty...
    return StaticMethodProperty(method)

ObjIdStr = lambda obj: f'<{type(obj).__name__} @{id(obj):08x}>'

def ClassMethod (method):
    '''Decorator to turn a method into a class method.'''

    ftn_name = method.__name__
    #print(f'@ClassMethod: {ftn_name}')

    class ClassMethodProperty:
        '''Property class to implement the class method wrapper.'''

        def __init__ (self, ftn):
            #print(f'{ObjIdStr(self)} init')
            self.method = ftn

        def __set_name__ (self, owner, name):
            # Remember the function's name...
            self.name = name

        def __get__ (self, obj, cls):
            '''Access the property.'''
            caller = '<null>' if obj is None else ObjIdStr(obj)
            #print(f'{ObjIdStr(self)} get: {caller}')
            def proxy (*args, **kwargs):
                '''Proxy function that wraps class method.'''
                return self.method(cls, *args, **kwargs)
            return proxy

        def __set__ (self, obj, value):
            '''(Only protects calls on instance objects.'''
            raise NotImplementedError(f'You may not modify {self.name}!')

        def __delete__ (self, obj):
            '''(Only protects calls on instance objects.'''
            raise NotImplementedError(f'You may not delete {self.name}!')

    # Return new instance of ClassMethodProperty...
    return ClassMethodProperty(method)

