def AddReprMethod (cls):
    '''Decorator function to modify repr() function of a class.'''
    #print(f'Change repr for {cls.__name__}')

    def my_repr (self):
        attrs = (f"{key}={val!r}" for key,val in vars(self).items())
        return f"{type(self).__name__}({', '.join(attrs)})"

    cls.__repr__ = my_repr
    return cls
