from time import sleep
from random import random
from examples import FunctionTimer

FAST = False
DELAY = 1/3
plural = lambda n: '' if n==1 else 's'

@FunctionTimer()
def fast_function (t=0.777, d=0.456):
    u = DELAY if FAST else t
    v = 0 if FAST else d
    sleep(u + (random() * v))

@FunctionTimer('group1')
def slow_function (t=2.71828, d=1.111):
    u = DELAY if FAST else t
    v = 0 if FAST else d
    sleep(u + (random() * v))

@FunctionTimer('group1')
def another_slow_function (t=2.71828, d=1.111):
    u = DELAY if FAST else t
    v = 0 if FAST else d
    sleep(u + (random() * v))

@FunctionTimer('group2')
def slower_function (t=3.14159, d=1.616):
    u = DELAY if FAST else t
    v = 0 if FAST else d
    sleep(u + (random() * v))

@FunctionTimer('group2')
def another_slower_function (t=3.14159, d=1.616):
    u = DELAY if FAST else t
    v = 0 if FAST else d
    sleep(u + (random() * v))

@FunctionTimer('group3')
def slowest_function (t=6.28318, d=2.718):
    u = DELAY if FAST else t
    v = 0 if FAST else d
    sleep(u + (random() * v))

if __name__ == '__main__':
    print()
    print('Running some slow functions... (be patient)\n')

    fast_function()
    slow_function()
    another_slow_function()
    fast_function()
    slower_function()
    another_slower_function()
    fast_function()

    print('\n...Hang in there...\n')

    fast_function()
    slow_function()
    another_slow_function()
    fast_function()
    slower_function()
    another_slower_function()
    fast_function()

    print('\n...Got a bit more to go...\n')

    fast_function()
    slow_function()
    another_slow_function()
    fast_function()
    slower_function()
    another_slower_function()
    fast_function()
    slowest_function()
    fast_function()
    slowest_function()
    fast_function()
    print('\n...Done!\n')

    for ch in FunctionTimer.data:
        grp = FunctionTimer.data[ch]
        print(f'[{ch}] ({len(grp)} function{plural(len(grp))})')

        for nam in sorted(grp):
            print(f':{nam}::')
            ts = [f'{d/pow(10,9):.6f}' for d in grp[nam]]
            print(f'{", ".join(ts)}')
            print()
    print()

