from time import perf_counter_ns

FunctionTimes = {'main':{}}

def FunctionTimer (group='main'):
    '''Decorator function for timing functions.'''
    #print(f'@FunctionTimer({group})')

    # Add requested group if it doesn't exist...
    if group not in FunctionTimes:
        FunctionTimes[group] = {}

    def decorator (function):
        '''The actual decorator function.'''
        func_name = function.__qualname__
        #print(f'@FunctionTimer.decorator({func_name})')

        if func_name not in FunctionTimes[group]:
            FunctionTimes[group][func_name] = [0.0]

        def wrapper (*args, **kwargs):
            '''The wrapper function.'''
            #print(f'FunctionTimer[{func_name}]')

            # Call the function and capture start and end NS...
            t0 = perf_counter_ns()
            retv = function(*args, **kwargs)
            t1 = perf_counter_ns() - t0

            # Log the total time and this call time...
            FunctionTimes[group][func_name][0] += t1
            FunctionTimes[group][func_name].append(t1)
            #print(f'[{func_name}]: {t1/pow(10,6)} msecs')

            # Return timed function's value (if any)...
            return retv

        # Return the wrapper function...
        return wrapper

    # Return the actual decorator function...
    return decorator

FunctionTimer.data = FunctionTimes

