from examples import String2Byte, Byte2String

'''Return an object's typename.'''
typename = lambda obj: type(obj).__name__

@String2Byte(2) # translate second argument to bytes
def function1 (n:int, data:bytes, z:float) -> bytes:
    '''Demo function #1.'''
    return data

@Byte2String(3) # translate third argument to str
def function2 (a:str, b:int, data:str) -> str:
    '''Demo function #2.'''
    return data

@String2Byte(0) # translate return value to bytes
def function3 (data:str, x:int) -> str:
    '''Demo function #3.'''
    return data

@Byte2String(0, 'utf16') # translate return value to UTF16 string...
def function4 (data:bytes, m:float, n:float) -> bytes:
    '''Demo function #4.'''
    return data

if __name__ == '__main__':
    print()

    retv = function1(11, 'Ćóñàφωċĥ', 3.14159)
    print(f'{retv} ({typename(retv)})')
    print()

    retv = function2('eb', 42, bytes("Hello",encoding='utf8'))
    print(f'{retv} ({typename(retv)})')
    print()

    retv = function3('질쯊췌쿎퇐폒', 21)
    print(f'{retv} ({typename(retv)})')
    print()

    retv = function4(bytes("World",encoding='utf16'), 2.7, 1.6)
    print(f'{retv} ({typename(retv)})')
    print()

