def Byte2String (which=1, encoding='utf8'):
    '''Decorator for converting bytes to string.'''
    #print(f'Byte2String({which}, {encoding})')

    # We expect 1,2,3, for argument indexes, 0 for return value...
    ix = which - 1

    def decorator (function):
        '''Decorator function.'''
        ftn_name = function.__qualname__
        #print(f'@Byte2String: {ftn_name}')

        def wrapper (*args):
            '''Wrapper function.'''
            _args = list(args)

            # Positive or zero index for arguments...
            if 0 <= ix:
                # Index and convert a passed argument...
                _args[ix] = str(_args[ix], encoding=encoding)

            # Call function...
            retv = function(*_args)

            # Negative index for return value...
            if ix < 0:
                # Convert return argument...
                return str(retv, encoding=encoding)

            # Return value...
            return retv

        # Return function wrapper...
        return wrapper

    # Return decorator function...
    return decorator

def String2Byte (which=1, encoding='utf8'):
    '''Decorator for converting string to bytes.'''
    #print(f'String2Byte({which}, {encoding})')

    # We expect 1,2,3, for argument indexes, 0 for return value...
    ix = which - 1

    def decorator (function):
        '''Decorator function.'''
        ftn_name = function.__qualname__
        #print(f'@String2Byte: {ftn_name}')

        def wrapper (*args):
            '''Wrapper function.'''
            _args = list(args)

            # Positive or zero index for arguments...
            if 0 <= ix:
                # Index and convert a passed argument...
                _args[ix] = bytes(_args[ix], encoding=encoding)

            # Call function...
            retv = function(*_args)

            # Negative index for return value...
            if ix < 0:
                # Convert return argument...
                return bytes(retv, encoding=encoding)

            # Return value...
            return retv

        # Return function wrapper...
        return wrapper

    # Return decorator function...
    return decorator

