def StringHandler (arg_indexes, kw_names, ftn_list):
    '''Decorator for string handling.'''

    def decorator (function):
        '''Actual decorator function.'''
        ftn_name = function.__qualname__
        #print(f'@StringHandler: {ftn_name}')

        def wrapper (*args, **kwargs):
            '''Wrapper function.'''
            #print(f'StringHandler: {args} {kwargs}')
            ftns = list(ftn_list) # (need mutable copies)
            _args = list(args)

            # Process positional arguments...
            for ax in arg_indexes:
                s = _args[ax]
                f = ftns.pop(0)
                _args[ax] = f(s)

            # Process keyword arguments...
            for kw in kw_names:
                s = kwargs[kw]
                f = ftns.pop(0)
                kwargs[kw] = f(s)

            # Call the function with modified args...
            retv = function(*tuple(_args), **kwargs)

            # (Optional) Process the return argument...
            if 0 < len(ftns):
                f = ftns.pop(0)
                retv = f(retv)

            # Return the function's return value...
            return retv

        # Return the function wrapper...
        return wrapper

    # Return the decorator...
    return decorator

