from examples import DataRecorder

@DataRecorder(2)
def function1 (x=0, y=0, z=0):
    '''Demo function #1.'''
    return x*y*z

@DataRecorder('y')
def function2 (x=0, y=0, z=0):
    '''Demo function #2.'''
    return x*y*z

if __name__ == '__main__':
    print()

    # Call function 1 a bunch of times...
    function1()
    function1(1)
    function1(1,2)
    function1(1,2,3)
    function1(4,5,6)
    function1(7,8,9)
    print()

    # Call function 2 a bunch of times...
    function2()
    function2(x=1,y=2)
    function2(x=2,z=9)
    function2(3, y=5)
    function2(x=7,y=8,z=9)
    print()

    # Dump function 1 stats...
    vals = ", ".join(f'[{ix}]{v}' for ix,v in function1.data)
    print(f'function1: {function1.count} calls')
    print(f'values: {vals}')
    print()

    # Dump function 2 stats...
    vals = ", ".join(f'[{ix}]{v}' for ix,v in function2.data)
    print(f'function2: {function2.count} calls')
    print(f'values: {vals}')
    print()

