def DataRecorder (which):
    '''Decorator for logging a specific parameter of function calls.'''
    #print(f'DataRecorder({which})')
    if not (isinstance(which,int) or isinstance(which,str)):
        raise TypeError(f'Parameter spec must be int or string.')

    def decorator (function):
        '''Actual decorator function returned in initialization.'''
        ftn_name = function.__qualname__
        #print(f'@DataRecorder: {ftn_name}')

        def wrapper (*args, **kwargs):
            '''Wrapper function.'''
            wrapper.count += 1
            #print(f'{ftn_name}[{wrapper.count}]: {args} {kwargs}')

            # An integer indexes a parameter in args...
            if isinstance(which,int) and (which < len(args)):
                arg = args[which]
                wrapper.data.append((wrapper.count, arg))

            # A string names a parameter in kwargs...
            elif isinstance(which,str) and (which in kwargs):
                arg = kwargs[which]
                wrapper.data.append((wrapper.count, arg))

            # Call wrapped function and return its result...
            return function(*args, **kwargs)

        # Initialize the wrapper object's special properties...
        wrapper.count = 0
        wrapper.data = []

        # Return the function wrapper...
        return wrapper

    # Return the decorator...
    return decorator

