from sys import argv
from examples import parse_multipart_form

FName = r'C:\Demo\Python\multipart-1.txt'
CType = r'multipart/form-data; boundary=----WebKitFormBoundaryFvgrhoe2FqQdLu4J'

def test_parser (file_name:str, content_type:str) -> tuple:
    '''Function to exercise Multipart parser.'''

    # Read multipart form data from file (binary mode)...
    fp = open(file_name, mode='rb')
    try:
        data = fp.read()
        print(f'loaded: {file_name}')
        print(f'bytes: {len(data)}')
        print()
    except:
        raise
    finally:
        fp.close()

    # Parse the multipart form...
    form,fname,ftype,fdata = parse_multipart_form(content_type, data)

    # List the form data...
    for key in sorted(form):
        val = form[key]

        if key == 'fn':
            print(f'{key}: <filedata>')
            continue

        if isinstance(val, str):
            print(f'{key}: {val}')
            continue

        print(f'{key}: {form[key].text}')

    print()

    return (form, fname, ftype, fdata)

if __name__ == '__main__':
    print(f'autorun: {argv[0]}')

    file_name = argv[1] if 1 < len(argv) else FName
    content_type = argv[2] if 2 < len(argv) else CType

    print()
    form,fname,ftype,fdata = test_parser(file_name, content_type)
    print()

