from sys import stdin
from os import environ
from urllib import parse

if __name__ == '__main__':
    # GET data...
    qs = environ.get('QUERY_STRING', '')
    get_dict = parse.parse_qs(qs)

    # POST data...
    post_len = int(environ.get('CONTENT_LENGTH', 0))
    post_txt = stdin.read(post_len)
    post_dict = parse.parse_qs(post_txt)

    form = dict(**get_dict, **post_dict)
    params = {}
    for name in sorted(form):
        value = form[name]
        # If it's a list of multiple items...
        if 1 < len(value):
            for ix,v in enumerate(value, start=1):
                params[f'{name}-{ix}'] = v
        # Otherwise it's just a name:value pair...
        else:
            params[name] = value[0]
    ...

