from json import load as jsonload

class config (dict):
    '''Basic configuration class.'''
    filename = r"C:\demo\hcc\python\configs.json"

    def __init__ (self, config_name='<default>'):
        '''New config instance.'''
        super().__init__()
        self['name'] = config_name

        # Auto load data...
        with open(self.filename, mode='rb') as fp:
            # Read JSON file...
            self.data = jsonload(fp)
            print('read: %s' % self.filename)

        # Get named configuration...
        self.configs = self.data['configs']

        # Load requested configuration...
        self.config = self.configs[config_name]

        # Put config values in the dictionary...
        self['lmargin'] = self.config['margin']['left']
        self['rmargin'] = self.config['margin']['right']
        self['tmargin'] = self.config['margin']['top']
        self['bmargin'] = self.config['margin']['bottom']
        self['lheight'] = self.config['line-height']
        self['pagnums'] = self.config['page-numbers']
        self['mode'] = self.config['mode']

    def __str__ (self):
        '''Pretty print.'''
        return f'config[{self["name"]}]'

    def margin (self):
        '''Return margin parameters as a tuple.'''
        lmar = self['lmargin']
        rmar = self['rmargin']
        tmar = self['tmargin']
        bmar = self['bmargin']
        return (lmar, rmar, tmar, bmar)

cfg1 = config()
cfg2 = config('8x11')
print()

print(cfg1)
print(f'mode: {cfg1["mode"]}')
print('left=%.2f, right=%.2f, top=%.2f, bot=%.2f' % cfg1.margin())
print()
print(cfg2)
print(f'mode: {cfg2["mode"]}')
print('left=%.2f, right=%.2f, top=%.2f, bot=%.2f' % cfg2.margin())
print()

