class point (tuple):
    '''Base point class.'''

    def __new__ (cls, *args, **kwargs):
        '''Create a new point object.'''
        arglst = list(args[0]) if len(args)==1 else args
        return super().__new__(cls, arglst)

    def __init__ (self, *args, precision=3, sep=', '):
        '''Initialize point object.'''
        super().__init__()
        self.precision = precision
        self.sep = sep

    def __str__ (self):
        '''Pretty print string.'''
        xs = [f'{self[ix]:+.{self.precision}f}' for ix in range(len(self))]
        return self.sep.join(xs)

    def dot_product (self, other):
        '''Return the dot product between this and another point.'''
        assert isinstance(other,point), ValueError('Invalid object')
        assert len(self)==len(other), ValueError('Lengths must match.')
        xs = [a*b for a,b in zip(self,other)]
        return sum(xs)

p1 = point(range(31,42), precision=0, sep=' ')
p2 = point(+2.1, -4.2, +6.3, -8.4, precision=2)
p3 = point(2.71814, 3.14159, 0.41468, 1.91027, precision=6)

print(p1)
print(p2)
print(p3)
print()
print(f'p2 dot p2: {p2.dot_product(p2)}')
print(f'p2 dot p3: {p2.dot_product(p3)}')
print()

