class numbers (list):
    '''Basic list of numbers.'''

    def __init__ (self, *args):
        '''Initialize. Takes a single iterable or a list of arguments.'''
        # We want a single list of objects...
        arglst = list(args[0]) if len(args) == 1 else args

        # Each list object must be numeric...
        for ix,a in enumerate(arglst, start=1):
            if isinstance(a,int): continue
            if isinstance(a,float): continue
            if isinstance(a,complex): continue
            if isinstance(a,bytes): continue
            raise ValueError(f'Illegal list item: #{ix}={a}')

        # Let list.__init__ build the list...
        super().__init__(arglst)

    def __str__ (self):
        '''Our string version.'''
        sn = ','.join([str(n) for n in self])
        return f'[{sn}]'

    @property
    def total (self):
        '''Return the total.'''
        return sum(self)

    @property
    def mean (self):
        '''Return the mean (average).'''
        return sum(self)/len(self)

    @property
    def low (self):
        '''Return the smallest number.'''
        return min(self)

    @property
    def high (self):
        '''Return the largest number.'''
        return max(self)

    @property
    def sumsquares (self):
        '''Return the sum of the number squares.'''
        return sum(self.squares)

    @property
    def squares (self):
        '''Return the squares of the numbers.'''
        return numbers(pow(a,2) for a in self)

    @property
    def cubes (self):
        '''Return the cubes of the numbers.'''
        return numbers(pow(a,3) for a in self)

from random import randint

ns = numbers(randint(10,1000) for _ in range(8))
print(ns)
print(f'sum = {ns.total}')
print(f'avg = {ns.mean:.3f} (min: {ns.low}, max: {ns.high})')
print(f'squares: {ns.squares}')
print()

