class my_dict (dict):
    def __new__ (cls, *args, **kwargs):
        '''Create a new my_dict object.'''
        print(f'dict::new({args}, {kwargs})')

        obj = super().__new__(cls, *args, **kwargs)
        print(f'dict::new: {obj}:{type(obj).__name__}')
        # Dictionary is empty at this point!

        # Return the new object...
        return obj

    def __init__ (self, *args, **kwargs):
        '''Initialize new my_dict object.'''
        print(f'dict::init({args}, {kwargs})')

        # Init takes same arguments...
        super().__init__(*args, **kwargs)
        # Now dict is populated!
        print(f'dict::init: {self}:{type(self).__name__}')
        # Init doesn't return anything...

