class my_tuple (tuple):
    def __new__ (cls, *args, **kwargs):
        '''Create a new my_tuple object.'''
        print(f'tuple::new({args}, {kwargs})')

        # Expects a single iterable arg; ignores keyword args...
        obj = super().__new__(cls, *args, **kwargs)
        # Tuple is populated at this point!
        print(f'tuple::new: {obj}:{type(obj).__name__}')

        # Return the new object...
        return obj

    def __init__ (self, *args, **kwargs):
        '''Initialize new my_tuple object.'''
        print(f'tuple::init({args}, {kwargs})')

        # Init takes no arguments...
        super().__init__()
        print(f'tuple::init: {self}:{type(self).__name__}')
        # And doesn't return anything...

