class my_list (list):
    def __new__ (cls, listobject=[]):
        '''Create a new my_list object.'''
        print(f'new({listobject})')

        # Expects a single iterable arg; ignores keyword args...
        obj = super().__new__(cls, listobject)
        print(f'new: {obj}:{type(obj).__name__}')
        # List is empty at this point!

        # Return the new object...
        return obj

    def __init__ (self, listobject=[]):
        '''Initialize new my_list object.'''
        print(f'init({listobject})')

        # Init takes same arguments...
        super().__init__(listobject)
        # Now list is populated!

        print(f'init: {self}:{type(self).__name__}')
        print()
        # Init doesn't return anything...


l0 = my_list()
l1 = my_list([1,2,3,4,5])
l2 = my_list('Hello!')
l3 = my_list(range(12))
print()

print(l0)
print(l1)
print(l2)
print(l3)
print()

