class my_class:
    '''A basic user-defined class.'''

    def __new__ (cls, **kwargs):
        '''Create a new instance object.'''
        print(f'new({kwargs})')

        # object.__new__ takes a class to instantiate...
        self = super().__new__(cls)
        # Object instance now exists...

        # Return the new object...
        print(f'new: {self!r}')
        return self

    def __init__ (self, x=0.0, y=0.0):
        '''Initialize new instance object.'''
        print(f'init({x} {y})')

        # object.__init__ takes no arguments...
        super().__init__()
        # Set object properties...
        self.x = x
        self.y = y

        # And doesn't return anything...
        print(f'init: {type(self).__name__}:{self}')
        print()

    def __repr__ (self):
        '''Representative string.'''
        return f'<{self.__class__.__name__} @{hex(id(self))}>'

    def __str__ (self):
        '''Pretty-print string.'''
        return f'[{self.x:.3f}, {self.y:.3f}]'


o1 = my_class()
o2 = my_class(x=2.7, y=3.1)

print(f'object1: {o1} @{hex(id(o1))}')
print(f'object2: {o2} @{hex(id(o2))}')
print()

