class a_class:
    '''A basic user-defined class template.'''

    def __new__ (cls):
        '''Create a new instance object.'''
        return super().__new__(cls)

    def __init__ (self):
        '''Initialize new instance object.'''
        super().__init__()

    def __str__ (self):
        '''Return a string version of the object.'''
        return "An object."

obj = a_class()
print()
print(f'{obj}')
print(f'{repr(obj)}')
print(f'{type(obj).__name__}')
print(f'id={hex(id(obj))}')
print()

obj.x = 42
obj.y = 21
print(f'x={obj.x}, y={obj.y}')
print()

