from math import sqrt
from turtle import Screen, Turtle

xmin, xmax = (-2000, +2000)
ymin, ymax = (-1500, +1500)

def do_turtle_program (program):
    '''Draw a given program of steps.'''

    # Get a Screen to draw on...
    wdw = Screen()
    wdw.setup(width=1500, height=1000, startx=0, starty=0)
    wdw.title(f'Turtle Test')
    wdw.mode('standard')
    wdw.colormode(255)
    wdw.setworldcoordinates(xmin,ymin, xmax,ymax)

    # Get a Turtle for drawing...
    tur = Turtle()
    tur.degrees()
    tur.speed("fast")
    tur.pensize(1)
    tur.pencolor(0,0,0)

    # Min/max vars for edge tracking...
    x0,x1, y0,y1 = 0,0,0,0

    # Draw the spiral...
    for cmd in program:
        match cmd[0]:
            # Draw a line, angle, distance...
            case 'line':
                # Turn...
                tur.left(cmd[1])
                # Forward...
                tur.forward(cmd[2])

            # Set the pen color...
            case 'color':
                tur.pencolor(cmd[1])

            # Set the pen color...
            case 'width':
                tur.pensize(cmd[1])

            # Set turtle heading to angle...
            case 'head':
                tur.setheading(cmd[1])

            # Move the turtle to X, Y...
            case 'move':
                tur.penup()
                tur.goto(cmd[1], cmd[2])
                tur.pendown()

            # Unknown command, so complain...
            case _:
                raise RuntimeError(f'Unknown command: "{cmd[0]}"')

        # Keep track of how big the space gets...
        x,y = tur.position()
        if x < x0: x0 = x
        if y < y0: y0 = y
        if x1 < x: x1 = x
        if y1 < y: y1 = y

    # Return the turtle to the start...
    tur.penup()
    tur.pencolor(0,0,0)
    tur.home()

    # Report how far the turtle went...
    print(f'Min/Max X: {x0}, {x1}')
    print(f'Min/Max Y: {y0}, {y1}')
    print()

diagonal = sqrt(pow(2000,2)+pow(1500,2))

program = [
    ('move', 2000,-1500), ('color', (0,0,255)), ('width', 3),
    ('line', 90, 3000),
    ('line', 90, 4000),
    ('line', 90, 3000),
    ('line', 90, 4000),
    ('move', 2000, 0), ('color', (255,0,0)), ('width', 2),
    ('line', 143.13, diagonal), # 180-36.87
    ('line',  73.74, diagonal), # 2 * 36.87
    ('line', 106.26, diagonal), # 180 - (2 * 36.87)
    ('line',  73.74, diagonal),
    ('head', 270), ('color', (0,0xcc,0)),  ('width', 4),
    ('line', 0, 4000),
]
do_turtle_program(program)

