from math import fmod
from turtle import Screen, Turtle

xmin, xmax = (-1300,  +700)
ymin, ymax = (-0000, +2000)

def euler_spiral (theta, steps=1200, distance=50):
    '''Draw an Euler Spiral.'''

    # Get a Screen to draw on...
    wdw = Screen()
    wdw.title(f'Euler Spiral - {theta:.12f} - {steps:,}')
    wdw.mode('standard')
    wdw.colormode(255)
    wdw.setworldcoordinates(xmin,ymin, xmax,ymax)

    # Get a Turtle for drawing...
    tur = Turtle()
    tur.degrees()
    tur.speed("fastest")
    tur.pensize(1)

    # Min/max vars for edge tracking...
    x0,x1, y0,y1 = 0,0,0,0

    # Draw the spiral...
    for ix in range(steps):
        # Forward...
        tur.forward(distance)
        # Turn left...
        tur.left(fmod(ix*theta, 360.0))
        # Crude "progress bar"...
        if (ix % 100) == 0:
            print(ix)

        # Keep track of how big the space gets...
        x,y = tur.position()
        if x < x0: x0 = x
        if y < y0: y0 = y
        if x1 < x: x1 = x
        if y1 < y: y1 = y

    # Return the turtle to the start...
    tur.penup()
    tur.home()

    # Report how far the turtle went...
    print(f'Min/Max X: {x0}, {x1}')
    print(f'Min/Max Y: {y0}, {y1}')
    print()

euler_spiral(1.123456789)

