from turtle import Screen, Turtle

def sierpinski_triangle (levels=6, distance=100, xmax=6400, ymax=5600):
    '''Draw the Sierpinski Triangle.'''

    def expand_string (s):
        '''Expand command string.'''
        buf = []
        for ch in s:
            # Expand X into Y+X+Y...
            if ch == 'X':
                buf.append('Y+X+Y')
                continue
            # Expand Y into X-Y-X...
            if ch == 'Y':
                buf.append('X-Y-X')
                continue
            buf.append(ch)
        return ''.join(buf)

    # Generate a drawing program LEVELS deep...
    program = 'X'
    for ix in range(levels):
        program = expand_string(program)

    # Get a Screen to draw on...
    wdw = Screen()
    wdw.title('Sierpinski Triangle')
    wdw.mode('standard')
    wdw.colormode(255)
    wdw.setworldcoordinates(-20,-20, xmax,ymax)

    # Get a Turtle for drawing...
    tur = Turtle()
    tur.degrees()
    tur.speed("fastest")
    tur.pensize(2)

    # Draw the Sierpinski Triangle...
    xlim, ylim = 0, 0
    for cmd in program:
        if cmd == '+':
            tur.forward(distance)
            tur.right(60)
        elif cmd == '-':
            tur.forward(distance)
            tur.left(60)

        # Keep track of how big the triangle gets...
        x,y = tur.position()
        if xlim < x: xlim = x
        if ylim < y: ylim = y

    tur.penup()
    tur.home()
    print(f'Maximum X: {xlim}')
    print(f'Maximum Y: {ylim}')
    print()

sierpinski_triangle(4, xmax=1600, ymax=1400)

