from random import random
from turtle import Screen, Turtle

xmin, xmax = (-2000, +2000)
ymin, ymax = (-2000, +2000)

def random_walk (steps=100, distance=100):
    '''Send the turtle on a random walk.'''
    # Get a turtle canvas...
    wdw = Screen()

    # Heading mode: east=0, angles counterclockwise...
    wdw.mode('standard')

    # Set canvas size...
    wdw.setworldcoordinates(xmin,ymin, xmax,ymax)

    # Set color mode [0-255] or [0-1.0]...
    wdw.colormode(255)

    # Get a turtle for drawing...
    tur = Turtle()

    # Using degrees (not radians)...
    tur.degrees()

    # Set speed of turtle animation...
    # (0-10 or fastest|fast|normal|slow|slowest)
    tur.speed("fastest")

    # Set width of drawn lines...
    tur.pensize(2)

    # Go for a (random) walk...
    for s in range(steps):
        tur.left(random()*360.0)
        tur.forward(dist)
        # Check for crossing window edge...
        x,y = tur.position()
        x0,y0 = x,y
        if x < xmin: x0 += (xmax - xmin)
        if xmax < x: x0 -= (xmax - xmin)
        if y < ymin: y0 += (ymax - ymin)
        if ymax < y: y0 -= (ymax - ymin)
        # Wrap around if necessary...
        if (x0 != x) or (y0 != y):
            tur.penup()
            tur.setposition(x0,y0)
            tur.pendown()

    # Draw a red dot at end of walk...
    tur.dot(10, (255,0,0))

    # Make the pen blue...
    tur.pencolor(0, 0, 255)
    tur.pensize(5)

    # Draw (blue) line back to start...
    tur.home()
    # s/a:
    #tur.setposition(0.0, 0.0)
    #tur.setheading(0)

    # Draw a red dot...
    tur.dot(10, (255,0,0))

random_walk(steps=1000, dist=200)

