def mechanical_fib_seq (seq_len):
    '''Mechanical Iterative Fibonacci sequence generator.'''
    seq = []

    # Start with an iterm in each hand...
    left_hand = 1
    right_hand = 1

    # Generate sequence with simple process...
    for ix in range(seq_len):
        # Copy left and right hands to pile...
        pile = left_hand + right_hand
        # Move left hand to sequence...
        seq.append(left_hand)
        # Move right hand to left hand...
        left_hand = right_hand
        # Move pile to right hand...
        right_hand = pile
        # Loop...

    # Return the Fibonacci sequence...
    return seq

