def array_fib_seq (seq_len):
    '''Array cache Fibonacci sequence generator.'''

    seq = [0]*seq_len
    seq[0] = 1
    seq[1] = 1
    seq[2] = 2

    def fib (n):
        if seq[n]: return seq[n]
        seq[n] = (fib(n-2) + fib(n-1))
        return

    for n in range(seq_len):
        fib(n)

    return seq

