from time import perf_counter_ns
from examples import fib_seq_print, print_timing, cached_fib_seq

def cached_fib_seq_demo (seq_len=100, print_list=True):
    '''Exercise the cached_fib_seq function.'''
    t0 = perf_counter_ns()

    fs = cached_fib_seq(seq_len)
    if print_list:
        fib_seq_print(fs)

    t1 = perf_counter_ns()
    print_timing('Name-Cache Fibonacci', seq_len, t1-t0)
    return fs

cached_fib_seq_demo()

