from examples import cache

def cached_fib_seq (seq_len):
    '''Cached Fibonacci sequence generator.'''

    @cache
    def fib (n):
        '''Canonical Recursive Fibonacci function.'''
        if n < 2: return 1
        return (fib(n-2) + fib(n-1))

    return [fib(n) for n in range(seq_len)]

