def cache (function):
    '''Cache Decorator for fib function.'''
    cache.previous = {}

    # Wrapper function for fib...
    def wrapper (n):
        if n in cache.previous:
            return cache.previous[n]

        # Actually call the fib function...
        r = function(n)
        cache.previous[n] = r
        return r

    return wrapper

