N = 15
clicks = []

def fibonacci (n):
    '''Canonical Recursive Fibonacci function.'''
    clicks.append(n)
    if n < 2: return 1
    return (fibonacci(n-2) + fibonacci(n-1))

def fibonacci_sequence (n):
    '''Fibonacci sequence recursively.'''
    print(f'Fibonacci Sequence: {n}')
    print()
    return [fibonacci(x) for x in range(n)]

fs = fibonacci_sequence(N)
print(fs)
print()
print(f'{len(clicks)} clicks')
print()

# Initialize histogram data...
histo = {d:0 for d in range(0,N)}

for d in clicks:
    histo[d] += 1

for d,times in sorted(histo.items()):
    print(f'{d}: {times} ')
print()

