'''Demos.py'''
from time import perf_counter_ns
import examples


def basic_fib_seq_demo (seq_len=30, print_list=True):
    '''Exercise the basic_fib_seq function.'''
    t0 = perf_counter_ns()

    fs = examples.basic_fib_seq(seq_len)
    if print_list:
        examples.fib_seq_print(fs)

    t1 = perf_counter_ns()
    examples.print_timing('Canonical Fibonacci', seq_len, t1-t0)
    return fs


def cached_fib_seq_demo (seq_len=100, print_list=True):
    '''Exercise the cached_fib_seq function.'''
    t0 = perf_counter_ns()

    fs = examples.cached_fib_seq(seq_len)
    if print_list:
        examples.fib_seq_print(fs)

    t1 = perf_counter_ns()
    examples.print_timing('Name-Cache Fibonacci', seq_len, t1-t0)
    return fs


def array_fib_seq_demo (seq_len=100, print_list=True):
    '''Exercise the array_fib_seq function.'''
    t0 = perf_counter_ns()

    fs = examples.array_fib_seq(seq_len)
    if print_list:
        examples.fib_seq_print(fs)

    t1 = perf_counter_ns()
    examples.print_timing('Index-Cache Fibonacci', seq_len, t1-t0)
    return fs


def iterative_fib_seq_demo (seq_len=100, print_list=True):
    '''Exercise the iterative_fib_seq function.'''
    t0 = perf_counter_ns()

    fs = examples.iterative_fib_seq(seq_len)
    if print_list:
        examples.fib_seq_print(fs)

    t1 = perf_counter_ns()
    examples.print_timing('Iterative Fibonacci', seq_len, t1-t0)
    return fs


def mechanical_fib_seq_demo (seq_len=100, print_list=True):
    '''Exercise the mechanical_fib_seq function.'''
    t0 = perf_counter_ns()

    fs = examples.mechanical_fib_seq(seq_len)
    if print_list:
        examples.fib_seq_print(fs)

    t1 = perf_counter_ns()
    examples.print_timing('Mechanical Fibonacci', seq_len, t1-t0)
    return fs



'''eof'''
