import hashlib

class BloomFilterBase:
    '''Bloom Filter Base class.'''

    def __init__(self, size):
        '''New BloomFilterBase instance.'''

        # Size of the "bit" vector...
        self.size = size

        # Table of hash function constructors...
        self.hash_functions = [hashlib.md5,
                               hashlib.sha1,
                               hashlib.sha384,
                               hashlib.sha256,
                               hashlib.sha512]

        # Size of the hash function table...
        self.nhash = len(self.hash_functions)


    def _hash(self, data:str, which:int) -> int:
        '''Return a hash of data.'''

        # Get a valid index into the table of hashes...
        wx = which % len(self.hash_functions)

        # Get hash function constructor from the table...
        hf = self.hash_functions[wx]

        # Get hash function...
        hasher = hf()

        # Send data through the hasher...
        hasher.update(data.encode('utf-8'))

        # Get the digest as hex string and convert to int...
        digest = int(hasher.hexdigest(), 16)

        # Return lower N bits of hash number...
        return digest % self.size

