from os import path
from examples import bf_charset, bf_char_check

BasePath = r'C:\users\wyrd\blog\hcc\source'

# Load a text file to scan...
fn = path.join(BasePath, 'chriscarol.txt')
with open(fn, mode='r', encoding='utf8') as fp:
    text = fp.read()

# Create a Bloom filter for special chars...
charval = [0x201c, 0x201d, 0x2018, 0x2019]
charset = [chr(v) for v in charval]

bf = bf_charset(charset, size=64)
print(''.join(str(b) for b in bf))
print()

# Scan through text file char by char...
for ix,ch in enumerate(text):
    # If Bloom filter returns True (possible match)...
    if bf_char_check(bf, ch, size=64):
        # Look for char in charset...
        if ch in charset:
            # List the char...
            print(f'{ix:04}: ({ch}) [0x{ord(ch):02x}]')
print()

