from examples import bf_charset, bf_char_check

# Special characters we're searching for...
charset = '\t\r\n\f\xa0'

# Some simple test text...
text = '\x80Foo\tBar\tGum\tZip\xa0\r\n'

# Create a Bloom filter for special chars...
bf = bf_charset(charset, size=16)
print(bf)
print()

# For each character in the text...
for ix,ch in enumerate(text):
    # If the Bloom filter returns a (maybe) match...
    if bf_char_check(bf, ch, size=16):
        # Print it (regardless)...
        print(f'found 0x{ord(ch):02x} @ index {ix}')
print()

