Sizes = [16, 32, 64, 128, 256]

def bf_charset (charset, size=32):
    '''Bloom filter for a small set of chars.'''
    assert size in Sizes, ValueError(f'Invalid size: {size}.')

    # Create mask for indexing vector...
    mask = size-1

    # Create vector of specified size...
    vector = [0]*size

    # Add each char in charset to filter...
    for ch in charset:
        # Use ordinal value as index...
        cx = ord(ch) & mask
        # Set vector "bit" to one...
        vector[cx] = 1

    # Return the filter vector...
    return vector

def bf_char_check (bf, char, size=32):
    '''Test for charset Bloom filter.'''
    assert size in Sizes, ValueError(f'Invalid size: {size}.')

    # Create mask for indexing vector...
    mask = size-1

    # Use ordinal value as index...
    cx = ord(char) & mask

    # Return filter bit...
    return bf[cx]

